﻿/// <reference name="MicrosoftAjax.js" />

MyComponent = function() {
    MyComponent.initializeBase(this, null);
}
MyComponent.prototype = {
   
    dispose: function() {
        Sys.Debug.trace(String.format("Component: {0} disposed", this.get_id()));
        MyComponent.callBaseMethod(this, 'dispose');
    }
}
MyComponent.registerClass("MyComponent", Sys.Component);

MyControl = function(element) {
    MyControl.initializeBase(this, [element]);
}; 
MyControl.prototype = {
    initialize: function() {
        var d = new Date();
        var newDiv = document.createElement("div");
        newDiv.style.cssText = String.format("position:absolute; top: {0}px; left: {1}px; width:45px; height:55px; background-color:red;",d.getMilliseconds().toString(),(d.getMilliseconds()/2).toString());
        document.body.appendChild(newDiv);
        MyControl.callBaseMethod(this, 'initialize');
    },
    dispose: function() {
        Sys.Debug.trace(String.format("Control: {0} disposed", this.get_id()));
        MyControl.callBaseMethod(this, 'dispose');
    }
};
MyControl.registerClass("MyControl", Sys.UI.Control);

MovingControl = function(element) {
    MovingControl.initializeBase(this, [element]);
}; 
MovingControl.prototype = {
    initialize: function() {
        var elm = this.get_element();
        elm.parentNode.removeChild(elm);
        document.body.appendChild(elm);
        
        MovingControl.callBaseMethod(this, 'initialize');
    },
    dispose: function() {
        Sys.Debug.trace(String.format("Control: {0} disposed", this.get_id()));
        MovingControl.callBaseMethod(this, 'dispose');
    }
};
MovingControl.registerClass("MovingControl", Sys.UI.Control);

Sys.Application.notifyScriptLoaded();
